<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRolesTable extends Migration {

	public function up()
	{
		Schema::create('roles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->unique()->nullable();
			$table->boolean('is_active')->default(true);
			$table->string('guard_name')->nullable();
			$table->string('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('roles');
	}
}