<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSocialLoginTable extends Migration {

	public function up()
	{
		Schema::create('social_login', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id')->unsigned();
			$table->string('provider')->nullable();
			$table->string('provider_id')->nullable();
			$table->string('access_token')->nullable();
			$table->string('refresh_token')->nullable();
			$table->timestamp('expired_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('social_login');
	}
}