<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Admin extends Eloquent {

	protected $table = 'admins';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function nationality()
	{
		return $this->belongsTo('Country', 'nationality_id');
	}

}