<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('work_item', function(Blueprint $table) {
			$table->foreign('work_list_id')->references('id')->on('work_lists')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('work_item', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('work_item', function(Blueprint $table) {
			$table->dropForeign('work_item_work_list_id_foreign');
		});
		Schema::table('work_item', function(Blueprint $table) {
			$table->dropForeign('work_item_user_id_foreign');
		});
	}
}