<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateKiosksTable extends Migration {

	public function up()
	{
		Schema::create('kiosks', function(Blueprint $table) {
			$table->increments('id');
			$table->string('kiosk_name', 255);
			$table->string('kiosk_number', 20);
			$table->string('location', 255);
			$table->decimal('gpslat', 10,8)->nullable();
			$table->decimal('gpslong', 11,8)->nullable();
			$table->string('created_by', 50)->nullable();
			$table->string('updated_by', 50)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('kiosks');
	}
}