<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Campaign extends Model 
{

    protected $table = 'campaign';
    public $timestamps = true;
    protected $fillable = array('status');

    public function campaign_amt()
    {
        return $this->hasMany('Campaign_donation_amount', 'campaign_id');
    }

    public function contribution_type()
    {
        return $this->hasMany('Contribution_type');
    }

    public function social_cause()
    {
        return $this->hasOne('Social_cause', 'social_cause_id');
    }

    public function campaign_contribution_type()
    {
        return $this->hasMany('Campaign_contribution_type');
    }

    public function campaign_stories()
    {
        return $this->hasMany('Campaign_stories');
    }

    public function campaign_inkind()
    {
        return $this->hasMany('Campaign_inkind');
    }

    public function campaign_location()
    {
        return $this->hasOne('Location', 'location_id');
    }

    public function campaign_img()
    {
        return $this->hasMany('Campaign_images');
    }

}