<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('ngo', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('location')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_donation_amount', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaign')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_contribution_type', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaign')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_contribution_type', function(Blueprint $table) {
			$table->foreign('contribution_type_id')->references('id')->on('contribution_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_images', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaign')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_stories', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaign')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_inkind', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaign')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_wishlist', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_wishlist', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaign')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_donation', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_donation', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaign')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_donation', function(Blueprint $table) {
			$table->foreign('ngo_id')->references('id')->on('ngo')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_donation', function(Blueprint $table) {
			$table->foreign('campaign_inkind_id')->references('id')->on('campaign_inkind')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_donation', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_donation', function(Blueprint $table) {
			$table->foreign('modified_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('faqs', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('faqs', function(Blueprint $table) {
			$table->foreign('modified_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('faq_category', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('faq_category', function(Blueprint $table) {
			$table->foreign('modified_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('ngo', function(Blueprint $table) {
			$table->dropForeign('ngo_user_id_foreign');
		});
		Schema::table('campaign', function(Blueprint $table) {
			$table->dropForeign('campaign_location_id_foreign');
		});
		Schema::table('campaign_donation_amount', function(Blueprint $table) {
			$table->dropForeign('campaign_donation_amount_campaign_id_foreign');
		});
		Schema::table('campaign_contribution_type', function(Blueprint $table) {
			$table->dropForeign('campaign_contribution_type_campaign_id_foreign');
		});
		Schema::table('campaign_contribution_type', function(Blueprint $table) {
			$table->dropForeign('campaign_contribution_type_contribution_type_id_foreign');
		});
		Schema::table('campaign_images', function(Blueprint $table) {
			$table->dropForeign('campaign_images_campaign_id_foreign');
		});
		Schema::table('campaign_stories', function(Blueprint $table) {
			$table->dropForeign('campaign_stories_campaign_id_foreign');
		});
		Schema::table('campaign_inkind', function(Blueprint $table) {
			$table->dropForeign('campaign_inkind_campaign_id_foreign');
		});
		Schema::table('user_wishlist', function(Blueprint $table) {
			$table->dropForeign('user_wishlist_user_id_foreign');
		});
		Schema::table('user_wishlist', function(Blueprint $table) {
			$table->dropForeign('user_wishlist_campaign_id_foreign');
		});
		Schema::table('user_donation', function(Blueprint $table) {
			$table->dropForeign('user_donation_user_id_foreign');
		});
		Schema::table('user_donation', function(Blueprint $table) {
			$table->dropForeign('user_donation_campaign_id_foreign');
		});
		Schema::table('user_donation', function(Blueprint $table) {
			$table->dropForeign('user_donation_ngo_id_foreign');
		});
		Schema::table('user_donation', function(Blueprint $table) {
			$table->dropForeign('user_donation_campaign_inkind_id_foreign');
		});
		Schema::table('user_donation', function(Blueprint $table) {
			$table->dropForeign('user_donation_created_by_foreign');
		});
		Schema::table('user_donation', function(Blueprint $table) {
			$table->dropForeign('user_donation_modified_by_foreign');
		});
		Schema::table('faqs', function(Blueprint $table) {
			$table->dropForeign('faqs_created_by_foreign');
		});
		Schema::table('faqs', function(Blueprint $table) {
			$table->dropForeign('faqs_modified_by_foreign');
		});
		Schema::table('faq_category', function(Blueprint $table) {
			$table->dropForeign('faq_category_created_by_foreign');
		});
		Schema::table('faq_category', function(Blueprint $table) {
			$table->dropForeign('faq_category_modified_by_foreign');
		});
	}
}