<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCampaignTable extends Migration {

	public function up()
	{
		Schema::create('campaign', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 1000);
			$table->text('short_info');
			$table->longText('description');
			$table->longText('tax_detail');
			$table->bigInteger('viewed_by');
			$table->bigInteger('social_cause_id');
			$table->bigInteger('location_id')->unsigned();
			$table->string('featured', 10);
			$table->string('home_banner', 10);
			$table->float('min_amount');
			$table->boolean('status')->default(1);
			$table->integer('created_by');
			$table->integer('modified_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('campaign');
	}
}