<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSaquesTable extends Migration {

	public function up()
	{
		Schema::create('saques', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('tabela', 100);
			$table->integer('identificacao');
			$table->float('valor');
			$table->date('dtprevista');
			$table->datetime('dtconfirmado')->nullable();
			$table->datetime('dtregistrado');
		});
	}

	public function down()
	{
		Schema::drop('saques');
	}
}