<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Moment extends Model 
{

    protected $table = 'moments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function meals()
    {
        return $this->belongsToMany('MealMoment')->withPivot('id', 'quantity');
    }

    public function drinks()
    {
        return $this->belongsToMany('DrinkMoment')->withPivot('id', 'quantity');
    }

}