<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Meal extends Eloquent {

	protected $table = 'meals';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function recipes()
	{
		return $this->belongsToMany('Recipe');
	}

	public function ingredients()
	{
		return $this->belongsToMany('Ingredient');
	}

}