<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateElementsTable extends Migration {

	public function up()
	{
		Schema::create('elements', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid', 64);
			$table->integer('parent_id');
			$table->string('name', 64);
			$table->string('description', 64);
			$table->tinyInteger('isAvailable');
			$table->integer('order');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('elements');
	}
}