<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Recipe extends Eloquent {

	protected $table = 'recipes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function ingredients()
	{
		return $this->belongsToMany('Ingredient');
	}

	public function elements()
	{
		return $this->belongsToMany('Elementable');
	}

}