<?php

namespace Modules\Event\Entities\Event;;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Event extends Eloquent {

	protected $table = 'events';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function moments()
	{
		return $this->hasMany('Moment');
	}

	public function elements()
	{
		return $this->morphToMany('Elementable');
	}

}