<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRecipesTable extends Migration {

	public function up()
	{
		Schema::create('recipes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid', 64);
			$table->integer('unit_id');
			$table->string('name', 64);
			$table->text('description');
			$table->float('preparation_time');
			$table->integer('persons_number');
			$table->integer('lowest_orders_number');
			$table->integer('output');
			$table->integer('order');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('recipes');
	}
}