<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StockTransactions extends Model 
{

    protected $table = 'stock_transactions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function moveType()
    {
        return $this->hasOne('MovwTypes');
    }

    public function differences()
    {
        return $this->hasMany('StockTransactionDiffrences');
    }

    public function stockMovements()
    {
        return $this->hasMany('StockMovement');
    }

    public function warehouse()
    {
        return $this->hasOne('Warehouse');
    }

    public function order()
    {
        return $this->hasOne('Orders');
    }

}