<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStockTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('stock_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('invoice_number');
			$table->datetime('accept_date');
			$table->string('damage_status')->nullable();
			$table->integer('receipt_amount');
			$table->integer('count_amount')->nullable();
			$table->boolean('count_match')->nullable();
			$table->integer('move_type_id');
			$table->boolean('restock_status');
			$table->integer('user_id');
			$table->integer('warehouse_id');
			$table->string('exit_location');
			$table->string('arrival_location');
		});
	}

	public function down()
	{
		Schema::drop('stock_transactions');
	}
}