<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StockMovement extends Eloquent {

	protected $table = 'stock_movements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function product()
	{
		return $this->hasOne('Product');
	}

	public function transaction()
	{
		return $this->belongsTo('StockTransactions');
	}

	public function warehouse()
	{
		return $this->hasOne('Warehouse');
	}

}