<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('status_id');
			$table->string('vendor_reference_number');
			$table->string('platform_order_id');
			$table->integer('stock_transaction_id');
			$table->string('order_channel');
			$table->string('delivery_company');
			$table->string('delivery_company_barcode')->nullable();
			$table->string('recipient_name');
			$table->string('recipient_phone');
			$table->string('recipient_mail')->nullable();
			$table->string('city_id');
			$table->string('district_id');
			$table->string('address');
			$table->string('neighborhood')->nullable();
			$table->string('order_reference_number_1');
			$table->string('order_reference_number_2');
			$table->string('order_reference_number_3');
			$table->string('order_reference_number_4');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}