<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRfLeasesTable extends Migration {

	public function up()
	{
		Schema::create('rf_leases', function(Blueprint $table) {
			$table->increments('id');
			$table->date('start_date');
			$table->date('end_date');
			$table->date('handover_date');
			$table->enum('tenant_type', array('individual', 'company'));
			$table->bigInteger('rf_user_id')->unsigned();
			$table->string('contract_number', 191)->unique();
			$table->bigInteger('deal_owner_id')->unsigned();
			$table->enum('rental_type', array('all', 'detailed'));
			$table->double('rental_total_amount', 10.2)->default('0');
			$table->bigInteger('fit_out_status_id')->unsigned();
			$table->bigInteger('payment_schedule_id')->unsigned();
			$table->bigInteger('lease_escalations_type_id')->unsigned();
			$table->float('security_deposit_amount', 11.2)->nullable();
			$table->float('security_deposit_due_date', 8.11)->nullable();
			$table->text('terms_conditions');
			$table->bigInteger('status_id')->unsigned();
			$table->boolean('is_sub_lease')->default(1);
			$table->boolean('is_terms')->default(1);
			$table->string('source', 191)->nullable();
			$table->bigInteger('updated_by')->unsigned();
			$table->bigInteger('created_by')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('rf_leases');
	}
}