<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRfAdditionalFeesLeaseTable extends Migration {

	public function up()
	{
		Schema::create('rf_additional_fees_lease', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('rf_lease_id')->unsigned();
			$table->bigInteger('rf_additional_fees')->unsigned();
			$table->bigInteger('calculation_basis_id')->unsigned();
			$table->bigInteger('payment_frequency_id')->unsigned();
			$table->double('value', 10,2)->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('rf_additional_fees_lease');
	}
}