<?php

namespace RFTenant\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RfBuildings extends Eloquent {

	protected $table = 'rf_buildings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'rf_community_id', 'no_floors', 'year_build', 'map', 'is_active', 'created_by', 'updated_by');

	public function community()
	{
		return $this->belongsTo('RFTenant\Models\RfCommunity');
	}

	public function units()
	{
		return $this->hasMany('RFTenant\Models\RfUnits');
	}

}