<?php

namespace RFTenant\Models;

class RfSpecification extends Eloquent {

	protected $table = 'rf_specifications';
	public $timestamps = true;
	protected $fillable = array('name_ar', 'name_en', 'type', 'icon', 'is_active');

	public function units()
	{
		return $this->belongsToMany('RFTenant\Models\RfUnits');
	}

	public function specification_unit()
	{
		return $this->belongsToMany('RFTenant\Models\RfSpecificationUnit');
	}

	public function parent()
	{
		return $this->hasOne('RFTenant\Models\RfSpecification', 'parent_id');
	}

	public function childs()
	{
		return $this->hasMany('RFTenant\Models\RfSpecification', 'parent_id');
	}

}