<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRfLeaseEscalationsTable extends Migration {

	public function up()
	{
		Schema::create('rf_lease_escalations', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('fixed', 'percentage'));
			$table->date('start_date');
			$table->date('end_date')->nullable();
			$table->double('amount', 10.2)->default('0');
			$table->string('percentage')->nullable();
			$table->bigInteger('rf_lease_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('rf_lease_escalations');
	}
}