<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePayrollEmployeeSalaryTable extends Migration {

	public function up()
	{
		Schema::create('payroll_employee_salary', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->char('employee', 10);
			$table->char('epf_type', 2)->nullable()->default('D');
			$table->string('epf_no', 25)->nullable();
			$table->string('socso_type', 2)->nullable()->default('1');
			$table->string('socso_no', 25)->nullable();
			$table->string('eis_type', 2)->nullable()->default('1');
			$table->enum('tax_type', array(''));
			$table->string('tax_no', 50)->nullable();
			$table->string('tax_location')->nullable();
			$table->enum('epf_addition_coy_type', array(''));
			$table->decimal('epf_addition_coy_value', 8,2)->nullable();
			$table->enum('epf_addition_staff_type', array(''))->nullable();
			$table->decimal('epf_addition_staff_value', 8,2)->nullable();
			$table->decimal('income_basic', 10,2)->nullable()->default('0');
			$table->decimal('income_daily_wages', 10,2)->nullable()->default('0');
			$table->decimal('income_ot', 10,2)->nullable()->default('0');
			$table->decimal('income_rest_day', 10,2)->nullable()->default('0');
			$table->decimal('income_rest_day_ot', 10,2)->nullable()->default('0');
			$table->decimal('income_public_holiday', 10,2)->nullable()->default('0');
			$table->decimal('income_public_holiday_ot', 14,2);
			$table->decimal('income_unpaid_leave', 14,2);
			$table->decimal('income_annual_leave', 10,2)->nullable();
			$table->decimal('income_director_fee', 10,2)->nullable()->default('0');
			$table->decimal('income_allowance', 10,2)->nullable()->default('0');
			$table->decimal('income_other', 10,2)->nullable()->default('0');
			$table->decimal('income_bik', 10,2)->nullable()->default('0');
			$table->decimal('income_vola', 10,2)->nullable()->default('0');
			$table->decimal('deduct_tax', 10,2)->nullable()->default('0');
			$table->decimal('deduct_epf', 14,2);
			$table->string('deduct_socso');
			$table->decimal('deduct_eis', 14,2);
			$table->decimal('deduct_zakat', 14,2);
			$table->decimal('deduct_cp38', 14,2);
			$table->decimal('deduct_advance', 14,2);
			$table->decimal('epf_company', 14,2);
			$table->decimal('deduct_other', 14,2);
			$table->decimal('socso_company', 14,2);
			$table->decimal('eis_company', 14,2);
			$table->integer('child_relief_1');
			$table->string('child_relief_2');
			$table->string('child_relief_3');
			$table->string('child_relief_4');
			$table->string('child_relief_5');
			$table->decimal('total_child_relief', 14,2);
		});
	}

	public function down()
	{
		Schema::drop('payroll_employee_salary');
	}
}