<?php

namespace App\Model\Employee;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Employee extends Eloquent {

	protected $table = 'core_employee';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_type', 'id_no', 'home_address', 'email', 'tel_no', 'mobile_no', 'dob', 'gender', 'race', 'religion', 'resident_type', 'marital_status', 'nationality', 'is_disabled', 'is_native', 'passport_no', 'passport_expiry', 'workpass_no', 'workpass_expiry', 'health_card_no', 'health_card_expiry', 'bank', 'bank_account_no', 'ec_name', 'ec_address', 'ec_contact_no', 'sp_name', 'sp_nric', 'sp_passport_no', 'sp_address', 'sp_tax_no', 'sp_tax_location', 'sp_nationality', 'sp_dob', 'sp_religion', 'sp_is_disabled', 'working_days', 'locality', 'branch', 'department', 'section', 'position', 'direct_superior', 'secondary_superior', 'is_active', 'remarks', 'job_type');

	public function incomes()
	{
		return $this->hasMany('App\Model\Employee\Employee');
	}

	public function immediate_family()
	{
		return $this->hasMany('App\Model\Employee\ImmediateFamily');
	}

}