<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('payroll_employee_salary_trn', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('core_employee')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('core_employee_family', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('core_employee')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('payroll_employee_salary_trn', function(Blueprint $table) {
			$table->dropForeign('payroll_employee_salary_trn_employee_id_foreign');
		});
		Schema::table('core_employee_family', function(Blueprint $table) {
			$table->dropForeign('core_employee_family_employee_id_foreign');
		});
	}
}