<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChannelsTable extends Migration {

	public function up()
	{
		Schema::create('channels', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->string('name', 255);
			$table->text('description');
			$table->integer('subscription_price');
			$table->string('website_url', 255);
			$table->string('facebook_url', 255)->nullable();
			$table->string('twitter_url', 255)->nullable();
			$table->string('instagram_url', 255);
			$table->string('snapchat_url', 255)->nullable();
			$table->string('analytics_id', 255);
			$table->string('16x9_image', 255);
			$table->string('4x3_image', 255);
			$table->string('1x1_image');
			$table->boolean('is_visible')->default(0);
			$table->boolean('is_approved');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('channels');
	}
}