<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLiveStreamsTable extends Migration {

	public function up()
	{
		Schema::create('live_streams', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('channel_id')->unsigned();
			$table->string('title', 255);
			$table->text('description');
			$table->string('preview_image', 255);
			$table->string('poster_image', 255);
			$table->string('stream_url', 255);
			$table->integer('duration');
			$table->timestamp('published_date');
			$table->datetimeTz('begining_datetime');
			$table->datetimeTz('end_datetime');
			$table->enum('accessibility', array('free', 'subscription', 'ppv'));
			$table->enum('post_update_accessibilty', array('free', 'subscription', 'disabled'));
			$table->integer('ppv_price')->nullable();
			$table->boolean('is_live')->default(0);
			$table->boolean('is_visible')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('live_streams');
	}
}