<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('subcategories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subunits', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('subcategory_id')->references('id')->on('subcategories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->foreign('resource_id')->references('id')->on('resources')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->foreign('utilization_id')->references('id')->on('utilizations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sale_bills', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sale_bills', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sale_bills', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sale_bill_payments', function(Blueprint $table) {
			$table->foreign('sale_bill_id')->references('id')->on('sale_bills')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_sale_bill', function(Blueprint $table) {
			$table->foreign('sale_bill_id')->references('id')->on('sale_bills')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_sale_bill', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('histories', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('expenses', function(Blueprint $table) {
			$table->foreign('expense_item_id')->references('id')->on('expense_items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchase_bills', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchase_bills', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchase_bill_product', function(Blueprint $table) {
			$table->foreign('purchase_bill_id')->references('id')->on('purchase_bills')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchase_bill_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('purchase_bill_product', function(Blueprint $table) {
			$table->foreign('subunit_id')->references('id')->on('subunits')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('subcategories', function(Blueprint $table) {
			$table->dropForeign('subcategories_category_id_foreign');
		});
		Schema::table('subunits', function(Blueprint $table) {
			$table->dropForeign('subunits_unit_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_subcategory_id_foreign');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->dropForeign('packages_resource_id_foreign');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->dropForeign('packages_utilization_id_foreign');
		});
		Schema::table('sale_bills', function(Blueprint $table) {
			$table->dropForeign('sale_bills_client_id_foreign');
		});
		Schema::table('sale_bills', function(Blueprint $table) {
			$table->dropForeign('sale_bills_package_id_foreign');
		});
		Schema::table('sale_bills', function(Blueprint $table) {
			$table->dropForeign('sale_bills_user_id_foreign');
		});
		Schema::table('sale_bill_payments', function(Blueprint $table) {
			$table->dropForeign('sale_bill_payments_sale_bill_id_foreign');
		});
		Schema::table('product_sale_bill', function(Blueprint $table) {
			$table->dropForeign('product_sale_bill_sale_bill_id_foreign');
		});
		Schema::table('product_sale_bill', function(Blueprint $table) {
			$table->dropForeign('product_sale_bill_product_id_foreign');
		});
		Schema::table('histories', function(Blueprint $table) {
			$table->dropForeign('histories_user_id_foreign');
		});
		Schema::table('expenses', function(Blueprint $table) {
			$table->dropForeign('expenses_expense_item_id_foreign');
		});
		Schema::table('purchase_bills', function(Blueprint $table) {
			$table->dropForeign('purchase_bills_supplier_id_foreign');
		});
		Schema::table('purchase_bills', function(Blueprint $table) {
			$table->dropForeign('purchase_bills_user_id_foreign');
		});
		Schema::table('purchase_bill_product', function(Blueprint $table) {
			$table->dropForeign('purchase_bill_product_purchase_bill_id_foreign');
		});
		Schema::table('purchase_bill_product', function(Blueprint $table) {
			$table->dropForeign('purchase_bill_product_product_id_foreign');
		});
		Schema::table('purchase_bill_product', function(Blueprint $table) {
			$table->dropForeign('purchase_bill_product_subunit_id_foreign');
		});
	}
}