<?php

namespace App\Models;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;
	protected $fillable = array('name', 'subcategory_id', 'type', 'countable', 'special_price', 'price', 'number_of_available_pieces', 'number_of_minimum_pieces', 'about_to_decrease');

	public function subcategory()
	{
		return $this->belongsTo('App\Models\Subcategory');
	}

	public function sale_bills()
	{
		return $this->belongsToMany('App\Models\SaleBill')->withPivot('price','quantity','discount');
	}

	public function purchase_bills()
	{
		return $this->belongsToMany('App\Models\PurchaseBill')->withPivot('price','quantity','subunit');
	}

}