<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSaleBillsTable extends Migration {

	public function up()
	{
		Schema::create('sale_bills', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->bigInteger('client_id')->unsigned();
			$table->bigInteger('package_id')->unsigned();
			$table->date('entry_day')->nullable();
			$table->date('checkout_day')->nullable();
			$table->time('entry_time')->nullable();
			$table->time('checkout_time')->nullable();
			$table->enum('status', array('pending', 'done', 'confirmed'));
			$table->text('notes')->nullable();
			$table->float('discount')->nullable();
			$table->bigInteger('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('sale_bills');
	}
}