<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyEditLogTable extends Migration {

	public function up()
	{
		Schema::create('company_edit_log', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id');
			$table->integer('admin_id');
			$table->enum('action', array(''modified'', ''created''));
			$table->text('message');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('company_edit_log');
	}
}