<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id');
			$table->integer('stationary_id');
			$table->string('orderNo', 10);
			$table->integer('quantity');
			$table->integer('assigned_id');
			$table->enum('status', array('0', '1', '2', '3'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}