<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'companys';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function companyDesignations()
	{
		return $this->hasOne('CompanyDesignation', 'company_id');
	}

	public function companyAddress()
	{
		return $this->hasOne('CompanyAddress', 'company_id');
	}

	public function BillingAddress()
	{
		return $this->hasOne('CompanyTaxDetails', 'company_id');
	}

	public function Stationary()
	{
		return $this->hasOne('Stationary', 'company_id');
	}

	public function orders()
	{
		return $this->hasMany('Order', 'company_id');
	}

	public function credit()
	{
		return $this->hasOne('CompanyCredit', 'company_id');
	}

	public function BillingAddress()
	{
		return $this->hasMany('BillingAddress', 'company_id');
	}

	public function DeliveryAddress()
	{
		return $this->hasMany('DeliveryAddress', 'company_id');
	}

	public function companyProfile()
	{
		return $this->hasOne('CompanyProfile', 'company_id');
	}

	public function companyQuota()
	{
		return $this->hasOne('CompanyQuota');
	}

}