<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function userOrderPivote()
	{
		return $this->hasOne('PrinterOrder', 'user_id');
	}

	public function userProfile()
	{
		return $this->hasOne('UserProfile', 'user_id');
	}

}