<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyTaxDetailsTable extends Migration {

	public function up()
	{
		Schema::create('company_tax_details', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('company_id');
			$table->integer('creditLimit')->default('0');
			$table->string('panNumber', 15);
			$table->string('tinNumber', 20);
			$table->string('stateRegister', 30);
			$table->text('paymentRemark');
		});
	}

	public function down()
	{
		Schema::drop('company_tax_details');
	}
}