<?php

namespace App/Model/Level;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Level extends Model 
{

    protected $table = 'levels';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('course_id', 'number', 'type', 'price', 'discount', 'status', 'active');

    public function course()
    {
        return $this->belongsTo('Course', 'course_id');
    }

}