<?php

namespace App/Model/StudentLesson;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StudentLesson extends Model 
{

    protected $table = 'student_lessons';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('lesson_id', 'student_id', 'start_date', 'status');

    public function lesson()
    {
        return $this->belongsTo('Lesson', 'lesson_id');
    }

    public function student()
    {
        return $this->belongsTo('Student', 'student_id');
    }

}