<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('students', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('full_name');
			$table->string('email');
			$table->string('password');
			$table->string('phone');
			$table->integer('is_active');
			$table->datetime('last_name');
			$table->integer('streak');
			$table->integer('total_medal')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('students');
	}
}