<?php

namespace App/Model/DownloadAttachement;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DownloadAttachement extends Model 
{

    protected $table = 'download_attachements';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('download_id', 'title', 'link', 'format', 'status');

    public function downloads()
    {
        return $this->belongsTo('Download', 'dawonload_id');
    }

}