<?php

namespace App/Model/Faqs;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Faqs extends Model 
{

    protected $table = 'faqs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('question', 'answer', 'faq_category_id');

    public function faqCategories()
    {
        return $this->belongsTo('FaqCategories', 'faq_category_id');
    }

}