<?php

namespace App/Model/Lesson;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lesson extends Model 
{

    protected $table = 'lessons';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('unit_id', 'number', 'title', 'description', 'Complete', 'notes');

    public function unit()
    {
        return $this->belongsTo('Unit', 'unit_id');
    }

}