<?php

namespace App/Model/LessonFaq;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LessonFaq extends Model 
{

    protected $table = 'lesson_faqs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('lesson_id', 'question', 'answer', 'student_id', 'answerd_by', 'status');

    public function lesson()
    {
        return $this->belongsTo('Lesson', 'lesson_id');
    }

}