<?php

namespace App/Model/OrderItem;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderItem extends Model 
{

    protected $table = 'order_items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'course_id', 'level_id', 'sale_price', 'status');

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function course()
    {
        return $this->belongsTo('Course', 'course_id');
    }

    public function level()
    {
        return $this->belongsTo('Level', 'level_id');
    }

}