<?php

namespace App/Model/SliderImage;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SliderImage extends Model 
{

    protected $table = 'slider_images';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('image', 'page_id', 'status');

    public function page()
    {
        return $this->belongsTo('Page', 'page_id');
    }

}