<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLevelsTable extends Migration {

	public function up()
	{
		Schema::create('levels', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('course_id')->unsigned();
			$table->string('number');
			$table->enum('type', array('free', 'paid', 'gift'));
			$table->double('price');
			$table->double('discount');
			$table->integer('status');
			$table->integer('active')->default('0');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('levels');
	}
}