<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuizStudentsTable extends Migration {

	public function up()
	{
		Schema::create('quiz_students', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('student_id')->unsigned();
			$table->bigInteger('quiz_id')->unsigned();
			$table->datetime('start');
			$table->datetime('end');
			$table->integer('degree');
			$table->integer('status');
			$table->integer('medal');
		});
	}

	public function down()
	{
		Schema::drop('quiz_students');
	}
}