<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('post_category_id')->unsigned()->nullable();
			$table->string('slug', 255)->unique();
			$table->enum('status', array('draft', 'publish'));
			$table->enum('is_pin_top', array('yes', 'no'));
			$table->string('title', 255);
			$table->text('brief');
			$table->text('content');
			$table->datetime('published_at');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->integer('created_by')->unsigned()->nullable();
			$table->integer('updated_by')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}