<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 200)->nullable();
			$table->string('company', 200)->nullable();
			$table->string('address_1', 200);
			$table->string('address_2', 200)->nullable();
			$table->string('city', 200);
			$table->string('state', 200);
			$table->string('postal_code', 50);
			$table->integer('country_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}